﻿using ConsoleApp2.Json;
using System;
using System.Diagnostics;
using System.Linq;

namespace ConsoleApp2
{
    public interface IJhrscom
    {
        ResponseResult GetResult(string a, DateTime dateTime, int id);

        ResponseResult GetPatient(Guid id, ResponseResult t);
    }

    public class Jhrscom : IJhrscom
    {
        [AutoCache(10)]
        public ResponseResult GetPatient(Guid id, ResponseResult t)
        {
            string key = GetKey(new object[] { id, t });
            ResponseResult result = new ResponseResult() { Code = 4444, Message = "第2个方法" };
            return result;
        }

        [AutoCache(cacheMinutes: 12, enableSliding: true)]
        public ResponseResult GetResult(string a, DateTime dateTime, int id)
        {
            ResponseResult result = new ResponseResult() { Code = 1122, Message = "缓存测试消息" };
            string key = GetKey(new object[] { a, dateTime, id });
            return result;
        }

        /// <summary>
        /// 缓存key
        /// </summary>
        /// <param name="pars"></param>
        /// <returns></returns>
        private string GetKey(params object[] pars)
        {
            var method = new StackFrame(1).GetMethod();
            var array = method.GetParameters();
            var key = array.Select(x => { return pars[x.Position].ToJson(); }).ToArray();

            var cacheKey = $"{method.DeclaringType.ToString()}|{method.Name.Replace("′", "")}|{string.Join("_", array.Select(x => x.Name))}|{string.Join("_", key)}".GetMd5();
            Console.WriteLine($"【{method.Name.Replace("′", "")}】实现类里面的缓存Key：" + cacheKey);
            return cacheKey;
        }
    }

    /// <summary>
    /// 输出结果
    /// </summary>
    public class ResponseResult
    {
        public int Code { get; set; }
        public string Message { get; set; }

        //.....其它属性
    }
}
